
global rImportBIP;
rollout rImportBIP ~RIMPORTBIP_CAPTION~ width:368 height:159
(
	local ini_file = ((getDir #plugcfg_ln) + "\\CAT\\importbip.ini");
	local catparent;
	local fhandle
	local filename;
	local camfile;	
	
--	checkbox chkResizeBIP ~CHKRESIZEBIP_CAPTION~ pos:[30,24] width:160 height:16 checked:true
	spinner spnHeight 	 ~SPNHEIGHT_CAPTION~ 			pos:[30,24] 	type:#float fieldwidth:55 range:[0,10000,0]
	
	checkbox chkCapAnim ~CHKCAPANIM_CAPTION~ pos:[30,45] width:~CHKCAPANIM_WIDTH~ height:16 checked:true
	button btnCamFile ~BTNCAMFILE_CAPTION~ pos:[30,70] width:120 height:24		

	progressBar pbImportBIP ~PBIMPORTBIP_CAPTION~ pos:[120,108] width:144 height:24
	label lblStatus ~LBLSTATUS_CAPTION~ pos:[8,108] width:111 height:33
	
	button btnOk ~BTNOK_CAPTION~ pos:[272,108] width:80 height:24
	
	fn SetStatus txt = 
	(
		lblStatus.text = txt;
	)
	
	fn GuessCATRigHeight =
	(
		catparent.catmode = 0;
	
		local head = catparent.roothub
		while head!=undefined and head.spines.count > 0 do
		(
			head = head.spines[1].tiphub
		)
		if catparent.lengthaxis == "Z" then
			 return (head.node.transform * Inverse(catparent.node.transform)).pos.z
		else return (head.node.transform * Inverse(catparent.node.transform)).pos.x
	)
	
	fn ImportBIP quiet:false =
	(	
		if catparent==undefined then return OK;
		-- ok, here we create a new biped, load in the bip file.
		-- then we use our crafy capture animation script to get the data onto CAT
		
	
		-- for some wird reason the importer causes havok with the motion panel rollout
		local panel = getCommandPanelTaskMode();
		setCommandPanelTaskMode mode:#display
	
		local capturebiped;
		with redraw off
		(	
			SetStatus ~SETSTATUS_CREATING_BIPED~
			capturebiped = biped.createNew spnHeight.value 0 [0, 0 , 0];
			pbImportBIP.value = 30.0
			SetStatus ~SETSTATUS_LOADING_BIP_FILE~

			biped.loadBipFile capturebiped.transform.controller filename #noRedraw #loadMaxObjects #loadSubAnimControllers	
		)	
		
		pbImportBIP.value = 100.0
		SetStatus ~SETSTATUS_BIP_FILE_LOADED~
		
		-- put us back on the panel we were in before import
		setCommandPanelTaskMode mode:panel
		
		if chkCapAnim.checked then
		(
			local timerange = (biped.getCurrentRange capturebiped.transform.controller)
			CaptureAnimation catparent capturebiped camfile:camfile quiet:quiet delsrc:true StartTime:timerange.start EndTime:timerange.end layername:(getFilenameFile filename)	
		)
	
	)
	
	fn Refresh =
	(
		if fname != undefined then
			rImportBIP.title = (~IMPORTING_BIP_TITLE~+ (getFilenameFile fname))
			
		if catparent==undefined then
		(
			chkCapAnim.enabled = false;
			btnCamFile.enabled = false; 
		)
		else
		(
			if camfile != undefined and (doesFileExist camfile) then
				 btnCamFile.text = (getFilenameFile camfile)
			else btnCamFile.text = ~BTNCAMFILE_BUTTONTEXT~
		)
	)

	fn openDialog catparentnode:undefined fname:undefined cam:undefined quiet:false height:-1 = 
	(
		if fname == undefined then (
			local lastfileloaded = getIniSetting ini_file ~LASTFILELOADED_CAPTION~ ~LASTFILELOADED~
			if(lastfileloaded.count == 0)then lastfileloaded = ((getDir #plugcfg_ln) + "\\CAT\\*.bip")
			
			fname = getOpenFileName caption:~FNAME_SELECT_A_BIP_FILE_TO_OPEN~ \
					                   types:~CHARACTER_STUDIO_FILE_TYPES~ \
									   filename:lastfileloaded
		)
		
		if fname != undefined then
			setIniSetting ini_file ~INI_FILE_FILES~ ~INI_FILE_LISTFILELOADED~ fname
		else return OK;

		local pos = execute (getIniSetting ini_file #general #position)
		if pos == ok then pos = [100, 100]
		createDialog rImportBIP pos:pos style:#(#style_border, #style_titlebar, #style_sysmenu);
		
		-------------------------------------------------------
		-- Now set the rollout values
		filename = fname;
		catparent = catparentnode;
		camfile = cam;
		
		str = getIniSetting ini_file ~INI_FILE_PARAMS~ ~INI_FILE_BIPEDHEIGHT~
		print str;
		print str.count
		if (str.count > 0) then 	spnHeight.value = str as number		
		else 						spnHeight.value = GuessCATRigHeight();
		
		str = getIniSetting ini_file ~GET_INI_FILE_PARAMS~ ~GET_INI_FILE_CAPTUREANIMATION~
		if (str.count > 0) then 	chkCapAnim.checked = execute str		
		
		camfile = getIniSetting ini_file ~CAMFILE_GET_INI_FILE_PARAMS~ "CAMFile"
		
		Refresh();
	)
	on btnCamFile pressed do
	(
		if camfile==undefined then(
			camfile = getIniSetting ini_file ~CAMFILE_PARAMS~ "CAMFile"
			if camfile==undefined then(
				camfile = ((getDir #plugcfg_ln) + "\\CAT\\*.cam")
			)
		)
		camfile = getOpenFileName caption:~CAMFILE_GETOPENFILENAME_CAPTION~ \
				                   types:~CAPTURE_ANIMATION_MAPPING_FILE_TYPES~ \
								   filename:camfile		
		Refresh()
	)
	on btnOk pressed do
	(
		ImportBIP();
		
	--	setIniSetting ini_file ~SETINISETTING_PARAMS~ ~SETINISETTING_RESIZEBIP~ (chkResizeBIP.checked as string)
		setIniSetting ini_file ~PARAMS~ ~BIPEDHEIGHT~ 		(spnHeight.value as string)
		setIniSetting ini_file ~SETINISETTING_INI_FILE_PARAMS~ ~SETINISETTING_INI_FILE_CAPTURE_ANIMATION~ 	(chkCapAnim.checked as string)
		if camfile!=undefined then setIniSetting ini_file ~CAMFILE_UNDEFINED_PARAMS~ "CAMFile" 	camfile
		
		DestroyDialog rImportBIP;
	)
)



fn CATImportBip catparentnode bipfile camfile:undefined quiet:false height:-1 = 
(	if quiet then
	(
		if height<=0 then
		(
			str = getIniSetting rImportBIP.ini_file ~RIMPORTBIP_INI_FILE_PARAMS~ ~RIMPORTBIP_INI_FILE_BIPEDHEIGHT~
			if (str.count > 0) then 	height = str as number		
			else 						height = rImportBIP.GuessCATRigHeight catparentnode;
		)
		
		rImportBIP.filename = fname;
		rImportBIP.catparent = catparentnode;
		rImportBIP.camfile = camfile;
		rImportBIP.filename = bipfile;
		rImportBIP.chkCapAnim.checked = true;
		rImportBIP.spnHeight.value = height;
		
		rImportBIP.ImportBIP quiet:true;
	)
	else
	(
		rImportBIP.openDialog catparentnode:catparentnode  fname:bipfile cam:camfile quiet:quiet height:height;
	)
)

